/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.items;

import com.alexander.mutantmore.config.MutantWitherSkeletonArmourCommonConfig;
import com.alexander.mutantmore.init.ItemInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.renderers.items.MutantWitherSkeletonSkullItemRenderer;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MutantWitherSkeletonArmourItem
extends GeoArmorItem
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final String BLOCK_ENTITY_TAG = "BlockEntityTag";
    public static final String BLOCK_STATE_TAG = "BlockStateTag";
    private final Block block;
    protected final Block wallBlock;
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private static final int[] DURABILITY_PER_SLOT = new int[]{13, 15, 16, 11};

    public MutantWitherSkeletonArmourItem(Block block, Block wallBlock, ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builder) {
        super(materialIn, slot, builder);
        this.block = block;
        this.wallBlock = wallBlock;
    }

    public int getDurabilityForSlot(EquipmentSlot slot) {
        return slot != null ? DURABILITY_PER_SLOT[slot.m_20749_()] * (Integer)MutantWitherSkeletonArmourCommonConfig.durability_multiplier.get() : 0;
    }

    public int getDefenseForSlot(EquipmentSlot slot) {
        int[] slotProtections = new int[]{(Integer)MutantWitherSkeletonArmourCommonConfig.boots_armour_value.get(), (Integer)MutantWitherSkeletonArmourCommonConfig.leggings_armour_value.get(), (Integer)MutantWitherSkeletonArmourCommonConfig.chestplate_armour_value.get(), (Integer)MutantWitherSkeletonArmourCommonConfig.helmet_armour_value.get()};
        return slot != null ? slotProtections[slot.m_20749_()] : 0;
    }

    public int getMaxDamage(ItemStack stack) {
        if (stack.m_41720_() instanceof MutantWitherSkeletonArmourItem && ((MutantWitherSkeletonArmourItem)stack.m_41720_()).f_40377_ != null) {
            return this.getDurabilityForSlot(((MutantWitherSkeletonArmourItem)stack.m_41720_()).f_40377_);
        }
        return 0;
    }

    public int m_6473_() {
        return (Integer)MutantWitherSkeletonArmourCommonConfig.enchantment_value.get();
    }

    public boolean m_6832_(ItemStack p_43311_, ItemStack p_43312_) {
        return p_43312_.m_204117_(TagInit.Items.REPAIRS_MUTANT_WITHER_SKELETON_ARMOUR);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        UUID uuid = ARMOR_MODIFIER_UUID_PER_SLOT[slot.m_20749_()];
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == EquipmentSlot.HEAD) {
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(uuid, "Attack Speed modifier", ((Double)MutantWitherSkeletonArmourCommonConfig.helmet_attack_speed_increase.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        if (slot == EquipmentSlot.CHEST) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(uuid, "Attack Damage modifier", ((Double)MutantWitherSkeletonArmourCommonConfig.chestplate_damage_increase.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.getDefenseForSlot(slot), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", ((Double)MutantWitherSkeletonArmourCommonConfig.armour_toughness.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        if ((Double)MutantWitherSkeletonArmourCommonConfig.knockback_resistance.get() > 0.0) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", ((Double)MutantWitherSkeletonArmourCommonConfig.knockback_resistance.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        ImmutableMultimap modifiers = builder.build();
        return slot == this.f_40377_ ? modifiers : super.m_7167_(slot);
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static void registerDispenseBehavior() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemInit.MUTANT_WITHER_SKELETON_SKULL.get()), (DispenseItemBehavior)ArmorItem.f_40376_);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemInit.MUTANT_WITHER_SKELETON_CHESTPLATE.get()), (DispenseItemBehavior)ArmorItem.f_40376_);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemInit.MUTANT_WITHER_SKELETON_LEGGINGS.get()), (DispenseItemBehavior)ArmorItem.f_40376_);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemInit.MUTANT_WITHER_SKELETON_BOOTS.get()), (DispenseItemBehavior)ArmorItem.f_40376_);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new MutantWitherSkeletonSkullItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return GeoArmorRenderer.getRenderer(((Object)((Object)MutantWitherSkeletonArmourItem.this)).getClass(), (Entity)livingEntity).applyEntityStats(original).applySlot(equipmentSlot).setCurrentItem(livingEntity, itemStack, equipmentSlot);
            }
        });
    }

    public InteractionResult m_6225_(UseOnContext p_40581_) {
        InteractionResult interactionresult = this.place(new BlockPlaceContext(p_40581_));
        if (!interactionresult.m_19077_() && this.m_41472_()) {
            InteractionResult interactionresult1 = this.m_7203_(p_40581_.m_43725_(), p_40581_.m_43723_(), p_40581_.m_43724_()).m_19089_();
            return interactionresult1 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : interactionresult1;
        }
        if (interactionresult == InteractionResult.FAIL) {
            return this.m_7203_(p_40581_.m_43725_(), p_40581_.m_43723_(), p_40581_.m_43724_()).m_19089_();
        }
        return interactionresult;
    }

    public InteractionResult place(BlockPlaceContext p_40577_) {
        if (!p_40577_.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockplacecontext = this.updatePlacementContext(p_40577_);
        if (blockplacecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(blockplacecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockplacecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockplacecontext.m_8083_();
        Level level = blockplacecontext.m_43725_();
        Player player = blockplacecontext.m_43723_();
        ItemStack itemstack = blockplacecontext.m_43722_();
        BlockState blockstate1 = level.m_8055_(blockpos);
        if (blockstate1.m_60713_(blockstate.m_60734_())) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, level, itemstack, blockstate1);
            this.updateCustomBlockEntityTag(blockpos, level, player, itemstack, blockstate1);
            blockstate1.m_60734_().m_6402_(level, blockpos, blockstate1, (LivingEntity)player, itemstack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, blockpos, itemstack);
            }
        }
        level.m_220407_(GameEvent.f_157797_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate1));
        SoundType soundtype = blockstate1.getSoundType((LevelReader)level, blockpos, (Entity)p_40577_.m_43723_());
        level.m_5594_(player, blockpos, this.getPlaceSound(blockstate1, level, blockpos, p_40577_.m_43723_()), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (player == null || !player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected SoundEvent getPlaceSound(BlockState state, Level world, BlockPos pos, Player entity) {
        return state.getSoundType((LevelReader)world, pos, (Entity)entity).m_56777_();
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext p_40609_) {
        return p_40609_;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos p_40597_, Level p_40598_, @Nullable Player p_40599_, ItemStack p_40600_, BlockState p_40601_) {
        return MutantWitherSkeletonArmourItem.updateCustomBlockEntityTag(p_40598_, p_40599_, p_40597_, p_40600_);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext p_40613_) {
        BlockState blockstate = this.wallBlock != null ? this.wallBlock.m_5573_(p_40613_) : null;
        BlockState blockstate1 = null;
        Level levelreader = p_40613_.m_43725_();
        BlockPos blockpos = p_40613_.m_8083_();
        for (Direction direction : p_40613_.m_6232_()) {
            BlockState blockstate2;
            if (direction == Direction.UP || this.getBlock() == null) continue;
            BlockState blockState = blockstate2 = direction == Direction.DOWN ? this.getBlock().m_5573_(p_40613_) : blockstate;
            if (blockstate2 == null || !blockstate2.m_60710_((LevelReader)levelreader, blockpos)) continue;
            blockstate1 = blockstate2;
            break;
        }
        return blockstate1 != null && levelreader.m_45752_(blockstate1, blockpos, CollisionContext.m_82749_()) ? blockstate1 : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos p_40603_, Level p_40604_, ItemStack p_40605_, BlockState p_40606_) {
        BlockState blockstate = p_40606_;
        CompoundTag compoundtag = p_40605_.m_41783_();
        if (compoundtag != null) {
            CompoundTag compoundtag1 = compoundtag.m_128469_(BLOCK_STATE_TAG);
            StateDefinition statedefinition = p_40606_.m_60734_().m_49965_();
            for (String s : compoundtag1.m_128431_()) {
                Property property = statedefinition.m_61081_(s);
                if (property == null) continue;
                String s1 = compoundtag1.m_128423_(s).m_7916_();
                blockstate = MutantWitherSkeletonArmourItem.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != p_40606_) {
            p_40604_.m_7731_(p_40603_, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState p_40594_, Property<T> p_40595_, String p_40596_) {
        return p_40595_.m_6215_(p_40596_).map(p_40592_ -> (BlockState)p_40594_.m_61124_(p_40595_, p_40592_)).orElse(p_40594_);
    }

    protected boolean canPlace(BlockPlaceContext p_40611_, BlockState p_40612_) {
        Player player = p_40611_.m_43723_();
        CollisionContext collisioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return this.block != null && (!this.mustSurvive() || p_40612_.m_60710_((LevelReader)p_40611_.m_43725_(), p_40611_.m_8083_())) && p_40611_.m_43725_().m_45752_(p_40612_, p_40611_.m_8083_(), collisioncontext);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext p_40578_, BlockState p_40579_) {
        return p_40578_.m_43725_().m_7731_(p_40578_.m_8083_(), p_40579_, 11);
    }

    public static boolean updateCustomBlockEntityTag(Level p_40583_, @Nullable Player p_40584_, BlockPos p_40585_, ItemStack p_40586_) {
        BlockEntity blockentity;
        MinecraftServer minecraftserver = p_40583_.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag compoundtag = MutantWitherSkeletonArmourItem.getBlockEntityData(p_40586_);
        if (compoundtag != null && (blockentity = p_40583_.m_7702_(p_40585_)) != null) {
            if (!(p_40583_.f_46443_ || !blockentity.m_6326_() || p_40584_ != null && p_40584_.m_36337_())) {
                return false;
            }
            CompoundTag compoundtag1 = blockentity.m_187482_();
            CompoundTag compoundtag2 = compoundtag1.m_6426_();
            compoundtag1.m_128391_(compoundtag);
            if (!compoundtag1.equals((Object)compoundtag2)) {
                blockentity.m_142466_(compoundtag1);
                blockentity.m_6596_();
                return true;
            }
        }
        return false;
    }

    public Block getBlock() {
        return this.getBlockRaw() == null ? null : (Block)ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)this.getBlockRaw()).get();
    }

    private Block getBlockRaw() {
        return this.block;
    }

    public void registerBlocks(Map<Block, Item> p_40607_, Item p_40608_) {
        if (this.getBlock() != null) {
            p_40607_.put(this.getBlock(), p_40608_);
        }
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        if (this.getBlock() != null) {
            blockToItemMap.remove(this.getBlock());
        }
    }

    public boolean m_142095_() {
        return this.block == null || !(this.block instanceof ShulkerBoxBlock);
    }

    public void m_142023_(ItemEntity p_150700_) {
        ItemStack itemstack;
        CompoundTag compoundtag;
        if (this.block != null && this.block instanceof ShulkerBoxBlock && (compoundtag = MutantWitherSkeletonArmourItem.getBlockEntityData(itemstack = p_150700_.m_32055_())) != null && compoundtag.m_128425_("Items", 9)) {
            ListTag listtag = compoundtag.m_128437_("Items", 10);
            ItemUtils.m_150952_((ItemEntity)p_150700_, listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_));
        }
    }

    @Nullable
    public static CompoundTag getBlockEntityData(ItemStack p_186337_) {
        return p_186337_.m_41737_(BLOCK_ENTITY_TAG);
    }

    public static void setBlockEntityData(ItemStack p_186339_, BlockEntityType<?> p_186340_, CompoundTag p_186341_) {
        if (p_186341_.m_128456_()) {
            p_186339_.m_41749_(BLOCK_ENTITY_TAG);
        } else {
            BlockEntity.m_187468_((CompoundTag)p_186341_, p_186340_);
            p_186339_.m_41700_(BLOCK_ENTITY_TAG, (Tag)p_186341_);
        }
    }

    public SoundEvent m_142602_() {
        return (SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_ARMOUR_EQUIP.get();
    }
}

